/** @file   Font.cpp
 * @brief   Implementation of Font class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/08 21:56:16 $
 * @author  Tomi Lamminsaari
 */

 
#include "Font.h"
#include "datatypes.h"
using std::string;

namespace eng2d {


//********************************************************************
//                                                                   *
//      Static members and constants                                 *
//                                                                   *
//********************************************************************



//********************************************************************
//                                                                   *
//      Constructors, destructor and operators                       *
//                                                                   *
//********************************************************************

/** Constructor.
 */
Font::Font() :
  m_pDatafile(0)
{
}



/** Constructs a new font and loads its data from given file.
 */
Font::Font(const string& filename) throw ( xIoError ):
  m_pDatafile(0)
{
  int ret = open(filename);
  if ( ret != KErrNone ) {
    throw xIoError( "Font", "Font(const string&)", "Failed to open the font" );
  }
}



/** Destructor.
 */
Font::~Font()
{
  close();
}



//********************************************************************
//                                                                   *
//      Public interface                                             *
//                                                                   *
//********************************************************************

/** Tries to load the font's data from given file.
 */
int Font::open(const string& filename)
{
  close();
  m_pDatafile = load_datafile(filename.c_str());
  if (m_pDatafile == 0) {
    return KErrRead;
  }
  return KErrNone;
}



/** Closes the font
 */
void Font::close()
{
  if (m_pDatafile != 0) {
    unload_datafile(m_pDatafile);
    m_pDatafile = 0;
  }
}



//********************************************************************
//                                                                   *
//      Public GET - methods                                         *
//                                                                   *
//********************************************************************

/** Returns a pointer to Allegro's FONT
 */
FONT* Font::al_FONT() const
{
  if ( m_pDatafile == 0 ) {
    return 0;
  }
  return reinterpret_cast<FONT*>( m_pDatafile[0].dat );
}



//********************************************************************
//                                                                   *
//      Private methods                                              *
//                                                                   *
//********************************************************************


}
